/*
  LuxTag SolidColor.js
  
*/

// global variables.
var version_num = "0.1";

var solidcolor_types = ["light"];

function helpSolidColorConversion( tag ) {
	var matType = solidcolor_types[ parseInt(tag.getParameter('solidcolor type')) ];
	
	switch( matType ) {
		case 'light':
			OS.messageBox("-- light --","emission -> Color\npower -> Intensity");
			break;
		default:
			OS.beep();
	}
}

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Lux SolidColor ]");
	
	//tag.addParameterSelector("shadeSelection", ["all", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"], true, false); // cause error :p
	tag.addParameterInt("shade selection", -1, -1, 15, true, false);
	tag.addParameterButton("SolidColor conv. help", "help", "helpSolidColorConversion");
	
	tag.addParameterSeparator("imagemap setting");
	tag.addParameterFloat("imagemap gamma", 2.2, 0.1, 6.0, true, false);
	
	tag.addParameterSeparator("emission settings");
	tag.addParameterFloat("power", 100, 0, 10000, true, false);
	tag.addParameterFloat("efficacy", 17, 0, 100, true, false);
	tag.addParameterFloat("gain", 1, 0, 100, true, false);
	
	tag.addParameterSeparator("[ SolidColor option ]");
	tag.addParameterSelector("solidcolor type", solidcolor_types, true, false);
	
}